#version 330 core
layout (location = 0) in vec4 vertex; // <vec2 pos, vec2 tex>
out vec2 TexCoords;

uniform mat4 view;
uniform mat4 cameraProjection;

uniform vec3 textWorldPos;

uniform int screenWidth;
uniform int screenHeight;

int iconSize = 50; //this is in pixels

uniform vec2 textPixelOffset;

void main()
{
	vec4 worldPos = cameraProjection * view * vec4(textWorldPos.xyz, 1.0);

	vec2 screenSpaceMultiplier = vec2(1.0 / float(screenWidth), 1.0 / float(screenHeight));

	vec2 vertexPos = (vertex.xy * float(iconSize) * screenSpaceMultiplier) + (textPixelOffset * screenSpaceMultiplier);


	gl_Position = worldPos;
	gl_Position /= gl_Position.w;

	gl_Position.xy += vertexPos;

  TexCoords = vertex.zw;
} 